Tech1NormalUnits =
{
	{ "e3", "e3", "e3", "e3", "e3" },
	{ "1tnk", "1tnk", "1tnk", "1tnk", "1tnk" },
	{ "2tnk.infonly", "2tnk.infonly", "2tnk.infonly", "2tnk.infonly", "2tnk.infonly" },
	{ "2tnk.infonly", "2tnk.infonly", "2tnk.infonly", "e3", "e3" }
}

Tech1HardUnits =
{
	{ "e3", "e3", "e3", "e3", "e3" },
	{ "1tnk", "1tnk", "1tnk", "1tnk", "1tnk" },
	{ "2tnk.infonly", "2tnk.infonly", "2tnk.infonly", "2tnk.infonly", "2tnk.infonly" },
	{ "2tnk.infonly", "2tnk.infonly", "2tnk.infonly", "e3", "e3" }
}

Tech5NormalUnits =
{
	{ "e3", "e3", "e3", "e3", "e3" },
	{ "1tnk", "1tnk", "1tnk", "1tnk", "1tnk" },
	{ "2tnk", "2tnk", "2tnk", "2tnk", "2tnk" },
	{ "2tnk", "2tnk", "2tnk", "e3", "e3" }
}

Tech5HardUnits =
{
	{ "e3", "e3", "e3", "e3", "e3" },
	{ "1tnk", "1tnk", "1tnk", "1tnk", "1tnk" },
	{ "2tnk", "2tnk", "2tnk", "2tnk", "2tnk" },
	{ "2tnk", "2tnk", "2tnk", "e3", "e3" }
}

InfantryRallypoints = { InfantryRallypoint1, InfantryRallypoint2 }
VehicleRallypoints = { VehicleRallypoint1, VehicleRallypoint2, VehicleRallypoint3 }

CheckExistenceForFAC1 = function()
	ConYard = Map.ActorsInBox(MCVTopLeft.CenterPosition, MCVBottomRight.CenterPosition, function(actor)
		return actor.Type == "fact" and actor.Owner == Player1
	end)

	return #ConYard >= 1
end

CheckHealth = function()
	if Map.LobbyOption("difficulty") == "hard" or Map.LobbyOption("difficulty") == "normal" then
		CheckHealthForFAC1()
		CheckHealthForTEN1()
		CheckHealthForWEA1()
		CheckHealthForFIX1()
	end
end

CheckHealthForFAC1 = function()
	Trigger.OnDamaged(FAC1, function()
		if FAC1.Owner == Player1 and FAC1.Health < FAC1.MaxHealth * 3/4 then
			FAC1.StartBuildingRepairs()
		end
		if FAC1.Owner == Player1 and FAC1.Health < FAC1.MaxHealth * 1/4 then
			FAC1.Sell()
		end
	end)

	Trigger.OnRemovedFromWorld(FAC1, function()
		DisableAdditionalUnitProduction()
	end)
end

DisableAdditionalUnitProduction = function()
	if AdditionalUnitProductionDisabled then
		return
	end

	TENP.Destroy()
	BARP.Destroy()
	KENP.Destroy()
	WEAP.Destroy()
	HPAP.Destroy()
	AFLP.Destroy()
	SYRP.Destroy()
	SPEP.Destroy()
	AGP1.Destroy()
	AGP2.Destroy()
	AGP3.Destroy()
	AdditionalUnitProductionDisabled = true
end

ProduceArmy = function()
	if Map.LobbyOption("techlevel") == "infantryonly" or Map.LobbyOption("techlevel") == "low" then
		if Map.LobbyOption("difficulty") == "normal" or Map.LobbyOption("difficulty") == "easy" then
			local toBuild = Utils.Random(Tech1NormalUnits)
			Player1.Build( toBuild, function(units)
				CreateTeam(units)
			end)
		end
		if Map.LobbyOption("difficulty") == "hard" then
			local toBuild = Utils.Random(Tech1HardUnits)
			Player1.Build( toBuild, function(units)
				CreateTeam(units)
			end)
		end
	end
	if Map.LobbyOption("techlevel") == "medium" or Map.LobbyOption("techlevel") == "nosuperweapons" or Map.LobbyOption("techlevel") == "unrestricted" then
		if Map.LobbyOption("difficulty") == "normal" or Map.LobbyOption("difficulty") == "easy" then
			local toBuild = Utils.Random(Tech5NormalUnits)
			Player1.Build( toBuild, function(units)
				CreateTeam(units)
			end)
		end
		if Map.LobbyOption("difficulty") == "hard" then
			local toBuild = Utils.Random(Tech5HardUnits)
			Player1.Build( toBuild, function(units)
				CreateTeam(units)
			end)
		end
	end
end

CreateTeam = function(units)
	Utils.Do(units, function(unit)
		SendAttack(unit)
	end)
end

SendAttack = function(unit)
	if not unit.IsDead then
		Trigger.OnIdle(unit, unit.Hunt) 
	end 
end

ControlInfantryRallypoints = function()
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		local TentFound = Player1.GetActorsByType("tent")

		Utils.Do(TentFound, function(unit)
			unit.RallyPoint = Utils.Random(InfantryRallypoints).Location
		end)
	end)
end

ControlVehicleRallypoints = function()
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		local WeapFound = Player1.GetActorsByType("weap")

		Utils.Do(WeapFound, function(unit)
			unit.RallyPoint = Utils.Random(VehicleRallypoints).Location
		end)
	end)
end

ShowMissionDetails = function()
	Media.DisplayMessage("There is an additional side ready for challenge.", "Battlefield Control")
	Trigger.AfterDelay(DateTime.Seconds(10), function()
		Media.DisplayMessage("Besides other possible opponents also Blue Group must be defeated in order to accomplish this mission.", "Battlefield Control")
	end)
end

CheckExistenceForInitialUnits = function()
	GuardExists = true
	Trigger.OnKilled(Guard, function() GuardExists = false end)
end

SendDefence = function()
	local defenders = Player1.GetGroundAttackers()
	if #defenders > 0 then
		Utils.Do(defenders, function(unit)
			unit.Hunt()

			if GuardExists then
				Guard.Stop()
			end
		end)
	end
end

ConsiderProtectionForHarvesters = function()
	Trigger.AfterDelay(DateTime.Seconds(60), function()
		DisableProtectionForHarvesters = false
		CheckHealthForHarvesters()
	end)
end

CheckHealthForHarvesters = function()
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		local Harvester = Player1.GetActorsByType("harv")

		Utils.Do(Harvester, function(unit)
			Trigger.OnDamaged(unit, function()
				if not DisableProtectionForHarvesters then
					SendDefence()
					DisableProtectionForHarvesters = true
				end
			end)
		end)
	end)
end

ConsiderHarvesterProduction = function()
	Trigger.AfterDelay(DateTime.Seconds(1), function()
		local Harvester = Player1.GetActorsByType("harv")

		if #Harvester < 2 then
			HarvesterNeeded = true
			Player1.Build({ "harv" }, function(harv)
				harv[1].FindResources()

				CheckHealthForHarvesters()
				ConsiderProtectionForHarvesters()
			end)
		end
		if #Harvester > 1 then
			HarvesterNeeded = false
		end
	end)
end

WorldLoaded = function()
	Player1 = Player.GetPlayer("Blue Group")
	Player1.Cash = 0
	
	Player2 = Player.GetPlayer("Multi0")
	Player3 = Player.GetPlayer("Multi1")
	Player4 = Player.GetPlayer("Multi2")
	Player5 = Player.GetPlayer("Multi3")
	Player6 = Player.GetPlayer("Multi4")
	Player7 = Player.GetPlayer("Multi5")
	Player8 = Player.GetPlayer("Multi6")
	Player9 = Player.GetPlayer("Multi7")

	ShowMissionDetails()
	CheckHealth()
	CheckExistenceForInitialUnits()
	CheckHealthForHarvesters()
	ConsiderProtectionForHarvesters()
end

Tick = function()
	if DateTime.GameTime % 100 == 0 then
		ControlInfantryRallypoints()
		ControlVehicleRallypoints()

		if not HarvesterNeeded then
			ProduceArmy()
		end
		ConsiderHarvesterProduction()
	end
end